<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // For SQLite, we need to recreate the table to modify enum
        // For MySQL, we can use ALTER TABLE
        if (DB::getDriverName() === 'sqlite') {
            // SQLite doesn't support ALTER TABLE for enum, so we'll skip this
            // The application will handle 'closed' status even if enum doesn't include it
            return;
        }

        // For MySQL/MariaDB
        DB::statement("ALTER TABLE ai_trade_bots MODIFY COLUMN status ENUM('active', 'paused', 'stopped', 'closed') DEFAULT 'active'");
    }

    public function down(): void
    {
        if (DB::getDriverName() === 'sqlite') {
            return;
        }

        // Revert to original enum values
        DB::statement("ALTER TABLE ai_trade_bots MODIFY COLUMN status ENUM('active', 'paused', 'stopped') DEFAULT 'active'");
    }
};

