<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('ai_trade_bots', function (Blueprint $table) {
            $table->timestamp('closed_at')->nullable()->after('status');
            $table->text('close_reason')->nullable()->after('closed_at');
        });
    }

    public function down(): void
    {
        Schema::table('ai_trade_bots', function (Blueprint $table) {
            $table->dropColumn(['closed_at', 'close_reason']);
        });
    }
};

