<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->decimal('admin_adjusted_profit_loss', 20, 8)->nullable()->after('profit_loss');
            $table->text('admin_adjustment_reason')->nullable()->after('admin_adjusted_profit_loss');
            $table->foreignId('adjusted_by')->nullable()->after('admin_adjustment_reason')->constrained('admin_users')->nullOnDelete();
            $table->timestamp('admin_adjusted_at')->nullable()->after('adjusted_by');
            $table->timestamp('admin_adjusted_executed_at')->nullable()->after('admin_adjusted_at');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropForeign(['adjusted_by']);
            $table->dropColumn([
                'admin_adjusted_profit_loss',
                'admin_adjustment_reason',
                'adjusted_by',
                'admin_adjusted_at',
                'admin_adjusted_executed_at'
            ]);
        });
    }
};

