<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('swaps', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('from_coin'); // BTC, ETH, USDT, etc.
            $table->decimal('from_amount', 20, 8);
            $table->string('to_coin'); // BTC, ETH, USDT, etc.
            $table->decimal('to_amount', 20, 8);
            $table->decimal('exchange_rate', 20, 8); // Rate used for swap
            $table->decimal('fee', 20, 8)->default(0); // Swap fee
            $table->enum('status', ['pending', 'processing', 'completed', 'failed'])->default('pending');
            $table->text('failure_reason')->nullable();
            $table->timestamps();
            $table->index(['user_id', 'status']);
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('swaps');
    }
};
