<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Set auto increment start from 648868
        // Check database driver and use appropriate SQL
        $driver = DB::getDriverName();
        
        if ($driver === 'mysql') {
            // MySQL syntax
            DB::statement('ALTER TABLE users AUTO_INCREMENT = 648868');
        } elseif ($driver === 'sqlite') {
            // SQLite syntax
            DB::statement("UPDATE sqlite_sequence SET seq = 648867 WHERE name = 'users'");
        }
    }

    public function down(): void
    {
        // Reset to default if needed
        if (DB::getDriverName() === 'mysql') {
            DB::statement('ALTER TABLE users AUTO_INCREMENT = 1');
        }
    }
};
