<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Hot Wallet, Cold Wallet, etc.
            $table->string('network'); // usdt-trc20, usdt-erc20, btc, eth
            $table->string('address');
            $table->enum('type', ['hot', 'cold'])->default('hot');
            $table->decimal('balance', 20, 8)->default(0);
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->index(['network', 'type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wallets');
    }
};
