<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('ai_trade_bot_id')->nullable()->constrained()->nullOnDelete();
            $table->string('order_type')->default('market'); // market, limit
            $table->string('side')->default('buy'); // buy, sell
            $table->string('trading_pair');
            $table->decimal('amount', 20, 8);
            $table->decimal('price', 20, 8)->nullable();
            $table->decimal('filled_amount', 20, 8)->default(0);
            $table->enum('status', ['pending', 'processing', 'filled', 'cancelled', 'failed'])->default('pending');
            $table->decimal('profit_loss', 20, 8)->default(0);
            $table->text('error_message')->nullable();
            $table->timestamp('executed_at')->nullable();
            $table->timestamps();
            $table->index(['user_id', 'status']);
            $table->index('ai_trade_bot_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
