<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ai_trade_bots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->string('trading_pair')->default('BTC/USDT');
            $table->decimal('leverage', 5, 2)->default(1);
            $table->decimal('amount', 20, 8);
            $table->decimal('weight_range_min', 5, 2)->default(0);
            $table->decimal('weight_range_max', 5, 2)->default(10);
            $table->decimal('quota_range_min', 20, 8)->default(500);
            $table->decimal('quota_range_max', 20, 8)->default(10000);
            $table->decimal('max_profit_percent', 5, 2)->default(3.00);
            $table->decimal('max_loss_percent', 5, 2)->default(1.50);
            $table->decimal('expected_return_min', 5, 2)->default(1.50);
            $table->decimal('expected_return_max', 5, 2)->default(3.00);
            $table->enum('status', ['active', 'paused', 'stopped'])->default('active');
            $table->json('strategy_config')->nullable();
            $table->decimal('total_profit', 20, 8)->default(0);
            $table->decimal('total_loss', 20, 8)->default(0);
            $table->timestamps();
            $table->index(['user_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ai_trade_bots');
    }
};
