<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('wallet_address')->unique()->nullable()->after('email');
            $table->string('wallet_type')->nullable()->after('wallet_address'); // metamask, coinbase, trust, etc.
            $table->decimal('balance', 20, 8)->default(0)->after('wallet_type');
            $table->decimal('locked_balance', 20, 8)->default(0)->after('balance');
            $table->string('account_weight_score')->default('0.00')->after('locked_balance');
            $table->string('authorization_quota')->default('0')->after('account_weight_score');
            $table->string('available_quota')->default('0')->after('authorization_quota');
            $table->string('invite_code')->unique()->nullable()->after('available_quota');
            $table->foreignId('referred_by')->nullable()->constrained('users')->nullOnDelete()->after('invite_code');
            $table->enum('kyc_status', ['pending', 'verified', 'rejected'])->default('pending')->after('referred_by');
            $table->boolean('is_active')->default(true)->after('kyc_status');
            $table->timestamp('last_login_at')->nullable()->after('is_active');
            $table->string('password')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['referred_by']);
            $table->dropColumn([
                'wallet_address', 'wallet_type', 'balance', 'locked_balance',
                'account_weight_score', 'authorization_quota', 'available_quota',
                'invite_code', 'referred_by', 'kyc_status', 'is_active', 'last_login_at'
            ]);
        });
    }
};
