<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Fix MySQL key length issue (max key length is 1000 bytes)
        // utf8mb4 uses 4 bytes per character, so 191 * 4 = 764 bytes (safe limit)
        Schema::defaultStringLength(191);

        View::composer('admin.layout', function ($view) {
            $view->with('playLoginSound', session()->pull('admin.just_logged_in'));
        });
    }
}
