<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'name', 'email', 'password', 'wallet_address', 'wallet_type',
        'balance', 'locked_balance', 'account_weight_score',
        'authorization_quota', 'available_quota', 'invite_code',
        'referred_by', 'kyc_status', 'is_verified', 'is_active', 'last_login_at',
        'withdrawal_pin_hash',
    ];

    protected $hidden = [
        'password', 'remember_token', 'withdrawal_pin_hash',
    ];

    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'balance' => 'decimal:8',
            'locked_balance' => 'decimal:8',
            'is_active' => 'boolean',
            'is_verified' => 'boolean',
            'last_login_at' => 'datetime',
        ];
    }

    // Relationships
    public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }

    public function withdrawals()
    {
        return $this->hasMany(Withdrawal::class);
    }

    public function swaps()
    {
        return $this->hasMany(Swap::class);
    }

    public function aiTradeBots()
    {
        return $this->hasMany(AiTradeBot::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function referrals()
    {
        return $this->hasMany(Referral::class);
    }

    public function referredBy()
    {
        return $this->belongsTo(User::class, 'referred_by');
    }

    public function referredUsers()
    {
        return $this->hasMany(User::class, 'referred_by');
    }

    public function supportTickets()
    {
        return $this->hasMany(SupportTicket::class);
    }

    public function supportMessages()
    {
        return $this->hasMany(SupportMessage::class, 'sender_id');
    }

    public function userBalances()
    {
        return $this->hasMany(UserBalance::class);
    }
}
