<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Swap extends Model
{
    protected $fillable = [
        'user_id', 'from_coin', 'from_amount', 'to_coin', 'to_amount',
        'exchange_rate', 'fee', 'status', 'failure_reason'
    ];

    protected function casts(): array
    {
        return [
            'from_amount' => 'decimal:8',
            'to_amount' => 'decimal:8',
            'exchange_rate' => 'decimal:8',
            'fee' => 'decimal:8',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
