<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SupportTicket extends Model
{
    protected $fillable = [
        'user_id',
        'subject',
        'status',
        'priority',
        'last_message_at'
    ];

    protected function casts(): array
    {
        return [
            'last_message_at' => 'datetime',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function messages(): HasMany
    {
        return $this->hasMany(SupportMessage::class, 'ticket_id')->orderBy('created_at', 'asc');
    }

    public function unreadMessages(): HasMany
    {
        return $this->hasMany(SupportMessage::class, 'ticket_id')
            ->where('is_read', false)
            ->where('sender_type', 'user') // For admin, unread = user messages
            ->orderBy('created_at', 'asc');
    }

    public function latestMessage(): HasMany
    {
        return $this->hasMany(SupportMessage::class, 'ticket_id')
            ->orderBy('created_at', 'desc')
            ->limit(1);
    }
}

