<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Referral extends Model
{
    protected $fillable = [
        'user_id', 'referred_user_id', 'level', 'commission_percent',
        'total_earnings', 'withdrawable'
    ];

    protected function casts(): array
    {
        return [
            'commission_percent' => 'decimal:2',
            'total_earnings' => 'decimal:8',
            'withdrawable' => 'decimal:8',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function referredUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'referred_user_id');
    }
}
