<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Order extends Model
{
    protected $fillable = [
        'user_id', 'ai_trade_bot_id', 'order_type', 'side', 'trading_pair',
        'amount', 'price', 'filled_amount', 'status', 'profit_loss',
        'error_message', 'executed_at', 'admin_adjusted_profit_loss',
        'admin_adjustment_reason', 'adjusted_by', 'admin_adjusted_at',
        'admin_adjusted_executed_at'
    ];

    protected function casts(): array
    {
        return [
            'amount' => 'decimal:8',
            'price' => 'decimal:8',
            'filled_amount' => 'decimal:8',
            'profit_loss' => 'decimal:8',
            'executed_at' => 'datetime',
            'admin_adjusted_profit_loss' => 'decimal:8',
            'admin_adjusted_at' => 'datetime',
            'admin_adjusted_executed_at' => 'datetime',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function aiTradeBot(): BelongsTo
    {
        return $this->belongsTo(AiTradeBot::class);
    }
}
