<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DiscoverPostLike extends Model
{
    protected $fillable = ['discover_post_id', 'user_id'];

    public function discoverPost(): BelongsTo
    {
        return $this->belongsTo(DiscoverPost::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
