<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DiscoverPostComment extends Model
{
    protected $fillable = ['discover_post_id', 'user_id', 'author_display', 'body'];

    public function discoverPost(): BelongsTo
    {
        return $this->belongsTo(DiscoverPost::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function authorDisplay(): string
    {
        if ($this->user_id) {
            return 'User ' . $this->user_id;
        }
        return 'User ' . ($this->author_display ?? 'D-0');
    }
}
