<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DiscoverPost extends Model
{
    protected $fillable = ['user_id', 'demo_author_id', 'content', 'image_path'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function likes(): HasMany
    {
        return $this->hasMany(DiscoverPostLike::class);
    }

    public function comments(): HasMany
    {
        return $this->hasMany(DiscoverPostComment::class)->orderBy('created_at');
    }

    public function authorDisplay(): string
    {
        if ($this->user_id) {
            return 'User ' . $this->user_id;
        }
        return 'User ' . ($this->demo_author_id ?? 'D-0');
    }
}
