<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DailyEarning extends Model
{
    protected $fillable = [
        'user_id', 'date', 'total_earnings', 'total_profit', 'total_loss',
        'total_trades', 'winning_trades', 'losing_trades'
    ];

    protected function casts(): array
    {
        return [
            'date' => 'date',
            'total_earnings' => 'decimal:8',
            'total_profit' => 'decimal:8',
            'total_loss' => 'decimal:8',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}

