<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AnnouncementComment extends Model
{
    protected $fillable = ['announcement_id', 'user_id', 'author_display', 'body'];

    public function announcement(): BelongsTo
    {
        return $this->belongsTo(Announcement::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function authorDisplay(): string
    {
        if ($this->user_id) {
            return 'User ' . $this->user_id;
        }
        return 'User ' . ($this->author_display ?? '0');
    }
}
