<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Announcement extends Model
{
    protected $fillable = ['demo_author_id', 'content', 'image_path'];

    public function likes(): HasMany
    {
        return $this->hasMany(AnnouncementLike::class);
    }

    public function comments(): HasMany
    {
        return $this->hasMany(AnnouncementComment::class)->orderBy('created_at');
    }

    /** Announcements are from the platform (admin / AI Bot), not individual users. */
    public function authorDisplay(): string
    {
        return 'AI Bot';
    }
}
