<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AiTradeBot extends Model
{
    protected $fillable = [
        'user_id', 'name', 'trading_pair', 'leverage', 'amount',
        'weight_range_min', 'weight_range_max', 'quota_range_min', 'quota_range_max',
        'max_profit_percent', 'max_loss_percent', 'expected_return_min', 'expected_return_max',
        'status', 'strategy_config', 'total_profit', 'total_loss', 'closed_at', 'close_reason',
        'admin_set_trading_time_minutes', 'admin_activated_at', 'time_based_profit_loss_rules'
    ];

    protected function casts(): array
    {
        return [
            'leverage' => 'decimal:2',
            'amount' => 'decimal:8',
            'weight_range_min' => 'decimal:2',
            'weight_range_max' => 'decimal:2',
            'quota_range_min' => 'decimal:8',
            'quota_range_max' => 'decimal:8',
            'max_profit_percent' => 'decimal:2',
            'max_loss_percent' => 'decimal:2',
            'expected_return_min' => 'decimal:2',
            'expected_return_max' => 'decimal:2',
            'strategy_config' => 'array',
            'total_profit' => 'decimal:8',
            'total_loss' => 'decimal:8',
            'closed_at' => 'datetime',
            'admin_activated_at' => 'datetime',
            'time_based_profit_loss_rules' => 'array',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }
}
