<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SuperAdmin
{
    public function handle(Request $request, Closure $next): Response
    {
        $adminUserId = $request->session()->get('admin.user_id');
        
        if (!$adminUserId) {
            return redirect()->route('admin.login');
        }

        $admin = \App\Models\AdminUser::find($adminUserId);
        
        if (!$admin || $admin->role !== 'super_admin') {
            abort(403, 'Super Admin access required');
        }

        return $next($request);
    }
}
