<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\App;

class SetAdminLocale
{
    public function handle(Request $request, Closure $next): Response
    {
        $locale = session('admin.locale', 'en');
        if (!in_array($locale, ['en', 'zh'], true)) {
            $locale = 'en';
        }
        App::setLocale($locale);
        return $next($request);
    }
}
