<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MarketController extends Controller
{
    public function index(Request $request)
    {
        // Mock market data - replace with real exchange API integration
        $markets = [
            ['pair' => 'BTC/USDT', 'price' => 95401.50, 'change' => 2.5, 'volume' => 621554000],
            ['pair' => 'ETH/USDT', 'price' => 3245.80, 'change' => -1.2, 'volume' => 182112000],
            ['pair' => 'BNB/USDT', 'price' => 615.20, 'change' => 0.8, 'volume' => 45123000],
        ];

        return response()->json([
            'success' => true,
            'markets' => $markets
        ]);
    }

    public function show(Request $request, $pair)
    {
        // Mock single market data
        $market = [
            'pair' => $pair,
            'price' => 95401.50,
            'change' => 2.5,
            'volume' => 621554000,
            'high_24h' => 96500.00,
            'low_24h' => 94200.00,
        ];

        return response()->json([
            'success' => true,
            'market' => $market
        ]);
    }
}
