<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\UserBalance;

class BalanceController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();
        
        // Get all balances for the user
        $balances = UserBalance::where('user_id', $user->id)
            ->where(function($query) {
                $query->where('balance', '>', 0)
                      ->orWhere('locked_balance', '>', 0);
            })
            ->orderBy('coin_name')
            ->get();

        return response()->json([
            'success' => true,
            'balances' => $balances
        ]);
    }
}
