<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;
use App\Models\SystemSetting;

class SystemController extends Controller
{
    public function index(): View
    {
        return view('admin.system.index', [
            'pageTitle' => __('admin.nav.system'),
            'title' => 'System Settings',
        ]);
    }

    public function update(Request $request): RedirectResponse
    {
        $validated = $request->validate([
            'system_name' => 'sometimes|string|max:255',
        ]);

        if (!empty($validated)) {
            \App\Models\AuditLog::create([
                'admin_user_id' => session('admin.user_id'),
                'action' => 'system_settings_update',
                'model_type' => SystemSetting::class,
                'model_id' => null,
                'changes' => json_encode($validated),
                'reason' => 'System settings updated',
            ]);
        }

        return redirect()->back()->with('success', 'Settings updated');
    }
}
