<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Referral;
use Illuminate\View\View;

class ReferralController extends Controller
{
    public function index(Request $request): View
    {
        $query = Referral::with(['user', 'referredUser']);

        if ($request->has('user_id')) {
            $query->where('user_id', $request->get('user_id'));
        }

        // Per page - default 10, allow 10, 20, 50, 100
        $perPage = $request->get('per_page', 10);
        if (!in_array($perPage, [10, 20, 50, 100])) {
            $perPage = 10;
        }

        $referrals = $query->latest()->paginate($perPage)->withQueryString();

        return view('admin.referrals.index', [
            'referrals' => $referrals,
            'pageTitle' => __('admin.nav.referrals'),
            'title' => 'Referral Management'
        ]);
    }
}
