<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AuditLog;
use Illuminate\View\View;

class AuditLogController extends Controller
{
    public function index(Request $request): View
    {
        $query = AuditLog::with('adminUser');

        if ($request->has('admin_user_id')) {
            $query->where('admin_user_id', $request->get('admin_user_id'));
        }

        if ($request->has('action')) {
            $query->where('action', $request->get('action'));
        }

        // Per page - default 10, allow 10, 20, 50, 100
        $perPage = $request->get('per_page', 10);
        if (!in_array($perPage, [10, 20, 50, 100])) {
            $perPage = 10;
        }

        $logs = $query->latest()->paginate($perPage)->withQueryString();

        return view('admin.audit-logs.index', [
            'logs' => $logs,
            'pageTitle' => __('admin.audit_logs.title'),
            'title' => 'Audit Logs'
        ]);
    }
}
