<?php

namespace App\Helpers;

class AssetHelper
{
    /**
     * Get admin asset URL (works in both dev and production)
     * Always resolves to /backend/public/{asset} for admin assets.
     * In production uses APP_URL so CSS loads on mobile (same host/scheme).
     */
    public static function adminAsset(string $asset): string
    {
        $asset = ltrim($asset, '/');

        if (app()->environment('production')) {
            $base = rtrim(config('app.url'), '/');
            $path = '/backend/public/' . $asset;
            $url = $base . $path;
            // Force HTTPS so mobile does not block mixed content
            if (str_starts_with($base, 'http://')) {
                $url = 'https://' . substr($base, 7) . $path;
            }
            return $url;
        }

        return asset($asset);
    }
}

