<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\OrderService;
use Illuminate\Support\Facades\Log;

class ProcessAiTradeBots extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ai-trade:process';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process active AI trading bots and create orders';

    /**
     * Execute the console command.
     */
    public function handle(OrderService $orderService)
    {
        $this->info('Processing active AI trading bots...');

        try {
            $results = $orderService->processActiveBots();

            $this->info("Processed: {$results['processed']} bots");
            $this->info("Orders created: {$results['orders_created']}");
            $this->info("Bots stopped: {$results['bots_stopped']}");
            
            if ($results['errors'] > 0) {
                $this->warn("Errors: {$results['errors']}");
            }

            Log::info('AI Trade Bot Processing', $results);

            return Command::SUCCESS;
        } catch (\Exception $e) {
            $this->error('Error processing bots: ' . $e->getMessage());
            Log::error('AI Trade Bot Processing Error: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
