<?php

namespace App\Console\Commands;

use App\Models\AdminUser;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class CreateAdmin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:create 
                            {--email=admin@example.com : Admin email}
                            {--password=admin12345 : Admin password}
                            {--role=super_admin : Admin role (super_admin or admin)}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create or update an admin user';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $email = $this->option('email');
        $password = $this->option('password');
        $role = $this->option('role');

        // Validate role
        if (!in_array($role, ['super_admin', 'admin'])) {
            $this->error('Role must be either "super_admin" or "admin"');
            return 1;
        }

        // Check if admin exists
        $admin = AdminUser::where('email', $email)->first();

        if ($admin) {
            // Update existing admin
            $admin->password = Hash::make($password);
            $admin->role = $role;
            $admin->is_active = true;
            $admin->save();
            
            $this->info("✅ Admin updated successfully!");
            $this->line("Email: {$email}");
            $this->line("Password: {$password}");
            $this->line("Role: {$role}");
        } else {
            // Create new admin
            $username = explode('@', $email)[0]; // Use email prefix as username
            
            AdminUser::create([
                'username' => $username,
                'email' => $email,
                'password' => Hash::make($password),
                'role' => $role,
                'is_active' => true,
            ]);
            
            $this->info("✅ Admin created successfully!");
            $this->line("Email: {$email}");
            $this->line("Password: {$password}");
            $this->line("Role: {$role}");
        }

        return 0;
    }
}

